/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.molding;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import slimeknights.mantle.recipe.ICommonRecipe;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.molding.IMoldingContainer;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public abstract class MoldingRecipe
implements ICommonRecipe<IMoldingContainer> {
    private final ResourceLocation id;
    private final Ingredient material;
    private final Ingredient pattern;
    private final boolean patternConsumed;
    private final ItemOutput recipeOutput;

    public boolean matches(IMoldingContainer inv, Level worldIn) {
        return this.material.test(inv.getMaterial()) && this.pattern.test(inv.getPattern());
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.material, this.pattern});
    }

    public ItemStack m_8043_() {
        return this.recipeOutput.get();
    }

    public MoldingRecipe(ResourceLocation id, Ingredient material, Ingredient pattern, boolean patternConsumed, ItemOutput recipeOutput) {
        this.id = id;
        this.material = material;
        this.pattern = pattern;
        this.patternConsumed = patternConsumed;
        this.recipeOutput = recipeOutput;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public Ingredient getMaterial() {
        return this.material;
    }

    public Ingredient getPattern() {
        return this.pattern;
    }

    public boolean isPatternConsumed() {
        return this.patternConsumed;
    }

    public static class Serializer<T extends MoldingRecipe>
    extends LoggingRecipeSerializer<T> {
        private final IFactory<T> factory;

        public T fromJson(ResourceLocation id, JsonObject json) {
            Ingredient material = Ingredient.m_43917_((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"material"));
            Ingredient pattern = Ingredient.f_43901_;
            boolean patternConsumed = false;
            if (json.has("pattern")) {
                pattern = Ingredient.m_43917_((JsonElement)json.get("pattern"));
                patternConsumed = GsonHelper.m_13855_((JsonObject)json, (String)"pattern_consumed", (boolean)false);
            }
            ItemOutput output = ItemOutput.fromJson((JsonElement)json.get("result"));
            return this.factory.create(id, material, pattern, patternConsumed, output);
        }

        @Nullable
        protected T fromNetworkSafe(ResourceLocation id, FriendlyByteBuf buffer) {
            Ingredient material = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient mold = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            boolean moldConsumed = buffer.readBoolean();
            ItemOutput output = ItemOutput.read((FriendlyByteBuf)buffer);
            return this.factory.create(id, material, mold, moldConsumed, output);
        }

        protected void toNetworkSafe(FriendlyByteBuf buffer, MoldingRecipe recipe) {
            recipe.material.m_43923_(buffer);
            recipe.pattern.m_43923_(buffer);
            buffer.writeBoolean(recipe.patternConsumed);
            recipe.recipeOutput.write(buffer);
        }

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }
    }

    @FunctionalInterface
    public static interface IFactory<T extends MoldingRecipe> {
        public T create(ResourceLocation var1, Ingredient var2, Ingredient var3, boolean var4, ItemOutput var5);
    }

    public static class Basin
    extends MoldingRecipe {
        public Basin(ResourceLocation id, Ingredient material, Ingredient mold, boolean moldConsumed, ItemOutput recipeOutput) {
            super(id, material, mold, moldConsumed, recipeOutput);
        }

        public RecipeSerializer<?> m_7707_() {
            return (RecipeSerializer)TinkerSmeltery.moldingBasinSerializer.get();
        }

        public RecipeType<?> m_6671_() {
            return (RecipeType)TinkerRecipeTypes.MOLDING_BASIN.get();
        }
    }

    public static class Table
    extends MoldingRecipe {
        public Table(ResourceLocation id, Ingredient material, Ingredient mold, boolean moldConsumed, ItemOutput recipeOutput) {
            super(id, material, mold, moldConsumed, recipeOutput);
        }

        public RecipeSerializer<?> m_7707_() {
            return (RecipeSerializer)TinkerSmeltery.moldingTableSerializer.get();
        }

        public RecipeType<?> m_6671_() {
            return (RecipeType)TinkerRecipeTypes.MOLDING_TABLE.get();
        }
    }
}

